cordova.define("cordova-plugin-utilities.GAPlugin", function(require, exports, module) {
/* global cordova */
var argscheck = require('cordova/argscheck');
var exec = require('cordova/exec');

var GAPlugin = function() {}

// log an event
//
// category = The event category. This parameter is required to be non-empty.
// eventAction = The event action. This parameter is required to be non-empty.
// eventLabel = The event label. This parameter may be a blank string to indicate no label.
// eventValue = The event value. This parameter may be -1 to indicate no value.
/**
 * @param success {Function} success callback
 * @param fail {Function} fail callback
 * @param category {string} The event category. This parameter is required to be non-empty.
 * @param eventAction {string} The event action. This parameter is required to be non-empty.
 * @param eventLabel [string] The event label. This parameter may be a blank string to indicate no label.
 * @param eventValue [number] The event value. This parameter may be -1 to indicate no value.
 */
GAPlugin.prototype.trackEvent = function(success, fail, category, eventAction, eventLabel, eventValue)
{
    return exec(success, fail, 'GAPlugin', 'trackEvent', [category, eventAction, eventLabel, eventValue]);
};


// log a page view
//
// pageURL = the URL of the page view
GAPlugin.prototype.trackPage = function(success, fail, pageURL)
{
    return exec(success, fail, 'GAPlugin', 'trackPage', [pageURL]);
};

module.exports = GAPlugin;
});
